/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class SplitModifier
extends NoLevelsModifier
implements ToolStatsModifierHook,
InventoryTickModifierHook,
ModifierRemovalHook,
TooltipModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkersinnovation", "split");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_STATS, ModifierHooks.INVENTORY_TICK, ModifierHooks.REMOVE, ModifierHooks.TOOLTIP});
    }

    private int getMaxAnotherDurability(IToolStackView tool) {
        return tool.getCurrentDurability();
    }

    private int getAnotherDurability(IToolStackView tool) {
        return Math.min(tool.getPersistentData().contains(this.KEY, 3) ? tool.getPersistentData().getInt(this.KEY) : 0, this.getMaxAnotherDurability(tool));
    }

    private void setAnotherDurability(IToolStackView tool, int amount) {
        tool.getPersistentData().putInt(this.KEY, Math.min(this.getMaxAnotherDurability(tool), Math.max(0, amount)));
    }

    private void addAnotherDurability(IToolStackView tool, int amount) {
        this.setAnotherDurability(tool, this.getAnotherDurability(tool) + amount);
    }

    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        ToolStats.DURABILITY.multiplyAll(builder, 0.4);
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (tool.isBroken() && this.getAnotherDurability(tool) > 0) {
            int swap = tool.getCurrentDurability() - tool.getDamage();
            tool.setDamage(this.getMaxAnotherDurability(tool) - this.getAnotherDurability(tool));
            this.setAnotherDurability(tool, swap);
        }
        if (holder.f_19797_ % 200 == 0 && this.getAnotherDurability(tool) < this.getMaxAnotherDurability(tool)) {
            this.addAnotherDurability(tool, 1);
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.tinkersinnovation.split_durability", (Object[])new Object[]{this.getAnotherDurability(tool)}));
    }
}

